<?php

# Copyright (c) Bouncing Ltd 2003-2015
# Author Philip Clarke nod@bouncing.org
# Released under the CC Attribution 4.0 licence https://creativecommons.org/licenses/by/4.0/
# You may do with it as you please just keep the credits. If you change something note it down for your own good
# This Version released 29/01/2015 (keep in as helps with bug fixes)


/* to help in case you have issues with PHP versions changing default error reporting values */

// development
ini_set('error_reporting', 'E_ALL | E_STRICT');
// ini_set('error_reporting', 'E_ALL & ~E_NOTICE');

// production
// ini_set('error_reporting', 'E_ALL & ~E_DEPRECATED');


// development
ini_set('display_errors', 'On');
// production
// ini_set('display_errors', 'Off');


# mysql_report is now mysqli_report PHP 5+ compatible
# General Principle for setting up.
# Get the mysql_report and fpdf libraries loaded
# Set the page side (although pdf's tend to scale well)
# add database connection details
# add report title
# Add SQL statement (it is sanitized in mysql_report but take precautions with any user input)
# Output PDF (lots of people forget this and then wonder why the page is blank).

// you may need to change mysql_report.php to find the fpdf libraries
require('mysql_report.php');


// the PDF is defined as normal, in this case a Landscape, measurements in points, A3 page.
$pdf = new PDF('L','pt','A4');
$pdf->SetFont('Arial','',10);


// change the below to establish the database connection.
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'rentals';

// should not need changing, change above instead.
$pdf->connect($host, $username, $password, $database);


// attributes for the page titles
$attr = array('titleFontSize'=>18, 'titleText'=>'Unbilled Accounts Report.');

# Example SQL Statements
# 
# Normally one would have 1 SQL statement and generate the report, e.g. a weekly sales breakdown
# mysql_report can now produce more than one SQL statement in the report, so one could do a 
# more complex set of tables like monthly reports using differing SQL
# Examples are from the mysql table. The tables are generated and then outputted.

/* Multiple SQL tables will merge into 1 numbered PDF */


/* Report 1: Unbilled Accounts Report */
// SQL statement
$sql_statement = "SELECT pname AS Property,accountno AS Account_No,c_name AS Client,c_office AS Office ,sb_date AS Value_Date FROM `unbilled_acc`";

// Generate report
$pdf->mysql_report($sql_statement, false, $attr );

/* Report 2: Commercial Leases expiring in 180 days Report.*/
// SQL statement
$attr = array('titleFontSize'=>18, 'titleText'=>'Commercial Leases expiring in 180 days Report.');


$sql_statement = 'SELECT pname AS Property,accountno AS Account_No,c_name AS Client,c_office AS Office ,e_date AS Value_Date FROM auto_com_expiry_180days';

// Generate report
$pdf->mysql_report($sql_statement, false, $attr );


/* Report 3: Commercial Expired Leases Report. */
// SQL statement
$attr = array('titleFontSize'=>18, 'titleText'=>'Commercial Expired Leases Report.');

$sql_statement = "SELECT *  FROM `auto_com_expired_leases`";

// Generate report
$pdf->mysql_report($sql_statement, false, $attr );

/* Report 4: Residential Leases expiring in 60 days Report.*/
// SQL statement
$attr = array('titleFontSize'=>18, 'titleText'=>'Residential Leases expiring in 60 days Report.');
$pdf->Ln();


$sql_statement = 'SELECT * FROM auto_res_expiry_60days';

// Generate report
$pdf->mysql_report($sql_statement, false, $attr );


/* Report 5: Residential Expired Leases Report. */
// SQL statement
$attr = array('titleFontSize'=>18, 'titleText'=>'Residential Expired Leases Report.');
$pdf->Ln();


$sql_statement = "SELECT *  FROM `auto_res_expired_leases`";

// Generate report
$pdf->mysql_report($sql_statement, false, $attr );


/* Report 6: Residential Rent Arreas Report.*/
// SQL statement
$attr = array('titleFontSize'=>18, 'titleText'=>'Residential Rent Arreas Report.');
$pdf->Ln();


$sql_statement = 'SELECT * FROM auto_res_arreas';

// Generate report
$pdf->mysql_report($sql_statement, false, $attr );


/* Report 7: Commercial Rent Arreas Report. */
// SQL statement
$attr = array('titleFontSize'=>18, 'titleText'=>'Commercial Rent Arreas Report.');
$pdf->Ln();


$sql_statement = "SELECT *  FROM `auto_com_arreas`";

// Generate report
$pdf->mysql_report($sql_statement, false, $attr );


$pdf->Output();

//$pdfoutputfile = 'multi.pdf';
//$pdfdoc = $pdf->Output($pdfoutputfile, 'F');


/* ADVICE do not use a PHP closing tag like  ?> */
