const { createElement, useState, useEffect, Fragment, render, useRef} = wp.element;
const { dispatch, select } = wp.data;


export const validateUrl = (value) => {
  return /^(?:(?:(?:https?|ftp):)?\/\/)(?:\S+(?::\S*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u00a1-\uffff0-9]-*)*[a-z\u00a1-\uffff0-9]+)(?:\.(?:[a-z\u00a1-\uffff0-9]-*)*[a-z\u00a1-\uffff0-9]+)*(?:\.(?:[a-z\u00a1-\uffff]{2,})))(?::\d{2,5})?(?:[/?#]\S*)?$/i.test(value);
}

export const IsJsonString = (str) => {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}

export const compareThis = (vars,array) =>{
  let flag = false;
  
  if(!Array.isArray(array))
      return false;

  if(Array.isArray(vars)){
    array.map((item)=>{
      if(vars.indexOf(item) > -1){
        flag= true;
      }
    });
  }else{
    Object.keys(vars).map((item) => {
      if(array.indexOf(item) > -1){
        flag= true;
      }
    });
  }
  
  return flag;
}