<?php

add_action( 'widgets_init', 'wplms_dash_weather_widget' );

function wplms_dash_weather_widget() {
    register_widget('wplms_weather');
}

class wplms_weather extends WP_Widget {

    /** constructor -- name this the same as the class above */
    function __construct() {
    $widget_ops = array( 'classname' => 'wplms_weather', 'description' => __('Weather App', 'wplms') );
    $control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'wplms_weather' );
    parent::__construct( 'wplms_weather', __(' DASHBOARD : Weather', 'wplms'), $widget_ops, $control_ops );

    add_action('wp_enqueue_scripts',array($this,'enqueue_script'));
        
    
    add_filter('vibebp_member_dashboard_widgets',array($this,'add_custom_script'));
  }
    
    function add_custom_script($args){
      $args[]='wplms_weather';
      return $args;
    }
        
    function enqueue_script(){
        if(bp_current_component() == 'dashboard' || apply_filters('vibebp_enqueue_profile_script',false)){
            wp_enqueue_script('wplms_weather',WPLMS_PLUGIN_URL.'/assets/js/weather_widget.js',array('wp-element'),WPLMS_PLUGIN_VERSION,true);
            wp_enqueue_style('wplms_dashboard_css',WPLMS_PLUGIN_URL.'/assets/css/dashboard.css',array(),WPLMS_PLUGIN_VERSION);
            wp_localize_script('wplms_weather','wplms_weather',apply_filters('wplms_weather',array(
              'settings'      => array(),
              'icons'=>array(
                'rain'=>'<svg style="margin: auto; background: rgb(255, 255, 255); display: block; shape-rendering: auto;" width="197px" height="197px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"> <defs> <path id="ldio-qb18bvb48qa-p1" d="M0 0v100h100V0H0z M62.9 44.4c-1.7 3.4-5.3 5.8-9.4 5.8H17c-5.8 0-10.5-4.7-10.5-10.5 c0-5.2 3.8-9.6 8.9-10.4c-0.1-0.6-0.2-1.3-0.2-2c0-5.5 4.4-9.9 9.9-9.9c1 0 2 0.2 3 0.5c2.5-4.7 7.4-7.9 13.1-7.9 c6.9 0 12.8 4.8 14.4 11.2c0.3 1.2 0.4 2.4 0.4 3.6c0 1.6-0.2 3.1-0.7 4.5c5 0.8 8.7 5.2 8.7 10.3C64 41.3 63.6 43 62.9 44.4z" transform="translate(-2.01959 0)"> <animateTransform attributeName="transform" type="translate" values="-3 0;3 0;-3 0" keyTimes="0;0.5;1" dur="4.166666666666666" repeatCount="indefinite" calcMode="spline" keySplines="0.5 0 0.5 1;0.5 0 0.5 1"></animateTransform> </path> <path id="ldio-qb18bvb48qa-p2" d="M0 52L58 52L64 47L100 47L100 90L0 90Z"></path> <clipPath id="ldio-qb18bvb48qa-cp1"><use xlink:href="#ldio-qb18bvb48qa-p1"></use></clipPath> <clipPath id="ldio-qb18bvb48qa-cp2"><use xlink:href="#ldio-qb18bvb48qa-p2"></use></clipPath> </defs> <g clip-path="url(#ldio-qb18bvb48qa-cp2)"><path fill="#ecf8ff" d="M26.1 61.7l1.6-4.3c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-1.6 4.3 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C24.9 63.1 25.8 62.6 26.1 61.7z" transform="translate(-16.376 43.6693)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="0s"></animateTransform> </path> <path fill="#ecf8ff" d="M34.4 68.6l4.2-11.1c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2L30.4 67 c-0.4 1.1 0.1 2.3 1.2 2.8c0.2 0.1 0.5 0.1 0.8 0.1C33.3 70 34.1 69.4 34.4 68.6z" transform="translate(-20.876 55.6692)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-0.20833333333333331s"></animateTransform> </path> <path fill="#ecf8ff" d="M42.7 75.4l6.8-18c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-6.8 18 c-0.4 1.1 0.1 2.3 1.2 2.8c0.2 0.1 0.5 0.1 0.8 0.1C41.6 76.8 42.4 76.3 42.7 75.4z" transform="translate(-25.376 67.6692)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-0.41666666666666663s"></animateTransform> </path> <path fill="#ecf8ff" d="M58.3 63.1l2.1-5.5c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-2.1 5.5 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C57.1 64.5 57.9 63.9 58.3 63.1z" transform="translate(-29.876 79.6693)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-0.625s"></animateTransform> </path> <path fill="#ecf8ff" d="M65.1 74.2l7.3-20.3c0.4-1.1-0.2-2.3-1.3-2.7c-1.1-0.4-2.3 0.2-2.7 1.3l-7.3 20.3 c-0.4 1.1 0.2 2.3 1.3 2.7c0.2 0.1 0.5 0.1 0.7 0.1C64 75.6 64.8 75.1 65.1 74.2z" transform="translate(10.624 -28.3308)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-0.8333333333333333s"></animateTransform> </path> <path fill="#ecf8ff" d="M77.4 66.8l4.3-13.1c0.4-1.1-0.2-2.3-1.4-2.7c-1.1-0.4-2.3 0.2-2.7 1.4l-4.3 13.1 c-0.4 1.1 0.2 2.3 1.4 2.7c0.2 0.1 0.4 0.1 0.7 0.1C76.3 68.3 77.1 67.7 77.4 66.8z" transform="translate(6.12404 -16.3308)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.0416666666666665s"></animateTransform> </path> <path fill="#ecf8ff" d="M16.9 86.4l6.4-17.3c0.4-1.1-0.2-2.3-1.3-2.8c-1.1-0.4-2.3 0.2-2.8 1.3l-6.4 17.3 c-0.4 1.1 0.2 2.3 1.3 2.8c0.2 0.1 0.5 0.1 0.7 0.1C15.7 87.8 16.6 87.2 16.9 86.4z" transform="translate(1.62402 -4.33073)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.25s"></animateTransform> </path> <path fill="#ecf8ff" d="M27.6 86.4l3.8-9.8c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-3.8 9.8 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C26.5 87.8 27.3 87.3 27.6 86.4z" transform="translate(-2.87597 7.66925)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.4583333333333333s"></animateTransform> </path> <path fill="#ecf8ff" d="M38.5 86.4l1-2.7c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-1 2.7 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C37.4 87.8 38.2 87.3 38.5 86.4z" transform="translate(-7.37596 19.6692)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.6666666666666665s"></animateTransform> </path> <path fill="#ecf8ff" d="M49.3 86.4l5.9-15.2c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-5.9 15.2 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C48.1 87.8 48.9 87.3 49.3 86.4z" transform="translate(-11.876 31.6692)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.8749999999999998s"></animateTransform> </path> <path fill="#ecf8ff" d="M72.2 81.9l2.9-7.7c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-2.9 7.7 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C71.1 83.3 71.9 82.8 72.2 81.9z" transform="translate(-16.376 43.6693)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-2.083333333333333s"></animateTransform> </path><path fill="#ecf8ff" d="M26.1 61.7l1.6-4.3c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-1.6 4.3 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C24.9 63.1 25.8 62.6 26.1 61.7z" transform="translate(6.12404 -16.3308)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.0416666666666665s"></animateTransform> </path> <path fill="#ecf8ff" d="M34.4 68.6l4.2-11.1c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2L30.4 67 c-0.4 1.1 0.1 2.3 1.2 2.8c0.2 0.1 0.5 0.1 0.8 0.1C33.3 70 34.1 69.4 34.4 68.6z" transform="translate(1.62405 -4.33079)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.2499999999999998s"></animateTransform> </path> <path fill="#ecf8ff" d="M42.7 75.4l6.8-18c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-6.8 18 c-0.4 1.1 0.1 2.3 1.2 2.8c0.2 0.1 0.5 0.1 0.8 0.1C41.6 76.8 42.4 76.3 42.7 75.4z" transform="translate(-2.87597 7.66925)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.458333333333333s"></animateTransform> </path> <path fill="#ecf8ff" d="M58.3 63.1l2.1-5.5c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-2.1 5.5 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C57.1 64.5 57.9 63.9 58.3 63.1z" transform="translate(-7.37596 19.6692)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.6666666666666665s"></animateTransform> </path> <path fill="#ecf8ff" d="M65.1 74.2l7.3-20.3c0.4-1.1-0.2-2.3-1.3-2.7c-1.1-0.4-2.3 0.2-2.7 1.3l-7.3 20.3 c-0.4 1.1 0.2 2.3 1.3 2.7c0.2 0.1 0.5 0.1 0.7 0.1C64 75.6 64.8 75.1 65.1 74.2z" transform="translate(-11.876 31.6692)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-1.8749999999999998s"></animateTransform> </path> <path fill="#ecf8ff" d="M77.4 66.8l4.3-13.1c0.4-1.1-0.2-2.3-1.4-2.7c-1.1-0.4-2.3 0.2-2.7 1.4l-4.3 13.1 c-0.4 1.1 0.2 2.3 1.4 2.7c0.2 0.1 0.4 0.1 0.7 0.1C76.3 68.3 77.1 67.7 77.4 66.8z" transform="translate(-16.376 43.6693)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-2.083333333333333s"></animateTransform> </path> <path fill="#ecf8ff" d="M16.9 86.4l6.4-17.3c0.4-1.1-0.2-2.3-1.3-2.8c-1.1-0.4-2.3 0.2-2.8 1.3l-6.4 17.3 c-0.4 1.1 0.2 2.3 1.3 2.8c0.2 0.1 0.5 0.1 0.7 0.1C15.7 87.8 16.6 87.2 16.9 86.4z" transform="translate(-20.876 55.6692)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-2.2916666666666665s"></animateTransform> </path> <path fill="#ecf8ff" d="M27.6 86.4l3.8-9.8c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-3.8 9.8 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C26.5 87.8 27.3 87.3 27.6 86.4z" transform="translate(-25.376 67.6693)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-2.5s"></animateTransform> </path> <path fill="#ecf8ff" d="M38.5 86.4l1-2.7c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-1 2.7 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C37.4 87.8 38.2 87.3 38.5 86.4z" transform="translate(-29.876 79.6693)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-2.708333333333333s"></animateTransform> </path> <path fill="#ecf8ff" d="M49.3 86.4l5.9-15.2c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-5.9 15.2 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C48.1 87.8 48.9 87.3 49.3 86.4z" transform="translate(10.624 -28.3308)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-2.916666666666666s"></animateTransform> </path> <path fill="#ecf8ff" d="M72.2 81.9l2.9-7.7c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-2.9 7.7 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C71.1 83.3 71.9 82.8 72.2 81.9z" transform="translate(6.12404 -16.3308)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="2.083333333333333" repeatCount="indefinite" begin="-3.1249999999999996s"></animateTransform> </path></g> <path fill="#c9ecff" d="M53.2 30.3c0.4-1.3 0.6-2.7 0.6-4.2c0-1.2-0.1-2.3-0.4-3.4c-1.5-6-7-10.5-13.5-10.5 c-5.3 0-9.9 3-12.3 7.4c-0.9-0.3-1.8-0.4-2.8-0.4c-5.1 0-9.3 4.1-9.3 9.3c0 0.6 0.1 1.3 0.2 1.9c-4.7 0.7-8.3 4.8-8.3 9.7 c0 5.4 4.4 9.8 9.8 9.8h34.2c3.8 0 7.1-2.2 8.8-5.4c0.7-1.3 1.1-2.9 1.1-4.5C61.4 35.2 57.8 31.1 53.2 30.3z" transform="translate(-2.01959 0)"> <animateTransform attributeName="transform" type="translate" values="-3 0;3 0;-3 0" keyTimes="0;0.5;1" dur="4.166666666666666" repeatCount="indefinite" calcMode="spline" keySplines="0.5 0 0.5 1;0.5 0 0.5 1"></animateTransform> </path> <g clip-path="url(#ldio-qb18bvb48qa-cp1)"> <path fill="#81cffa" d="M84.9 28.9c0.4-1.1 0.6-2.3 0.6-3.5c0-1-0.1-1.9-0.4-2.8 c-1.3-5-6.1-8.7-11.8-8.7c-4.6 0-8.7 2.5-10.7 6.1c-0.8-0.2-1.6-0.4-2.4-0.4c-4.5 0-8.1 3.4-8.1 7.6c0 0.5 0.1 1 0.2 1.5 c-4.1 0.6-7.2 4-7.2 8c0 4.5 3.8 8.1 8.6 8.1h29.8c3.3 0 6.2-1.8 7.7-4.4c0.6-1.1 0.9-2.3 0.9-3.7C92 32.9 88.9 29.6 84.9 28.9z" transform="translate(0.838833 0)"> <animateTransform attributeName="transform" type="translate" values="-3 0;3 0;-3 0" keyTimes="0;0.5;1" dur="2.75" repeatCount="indefinite" calcMode="spline" keySplines="0.5 0 0.5 1;0.5 0 0.5 1"></animateTransform> </path> </g></svg>',
      
      'clouds'=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="200px" height="200px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"> <g transform="translate(0 18)"> <path fill="#d1f8ff" d="M53.2,30.3c0.4-1.3,0.6-2.7,0.6-4.2c0-1.2-0.1-2.3-0.4-3.4c-1.5-6-7-10.5-13.5-10.5 c-5.3,0-9.9,3-12.3,7.4c-0.9-0.3-1.8-0.4-2.8-0.4c-5.1,0-9.3,4.1-9.3,9.3c0,0.6,0.1,1.3,0.2,1.9c-4.7,0.7-8.3,4.8-8.3,9.7 c0,5.4,4.4,9.8,9.8,9.8h34.2c3.8,0,7.1-2.2,8.8-5.4c0.7-1.3,1.1-2.9,1.1-4.5C61.4,35.2,57.8,31.1,53.2,30.3z" transform="translate(-0.52091 0)"> <animateTransform attributeName="transform" type="translate" values="-3 0;3 0;-3 0" keyTimes="0;0.5;1" dur="4.166666666666666" repeatCount="indefinite" calcMode="spline" keySplines="0.5 0 0.5 1;0.5 0 0.5 1"></animateTransform> </path> <defs> <path id="ldio-u4u0nkbf73c-path" d="M0,0v100h100V0H0z M62.9,44.4c-1.7,3.4-5.3,5.8-9.4,5.8H17c-5.8,0-10.5-4.7-10.5-10.5 c0-5.2,3.8-9.6,8.9-10.4c-0.1-0.6-0.2-1.3-0.2-2c0-5.5,4.4-9.9,9.9-9.9c1,0,2,0.2,3,0.5c2.5-4.7,7.4-7.9,13.1-7.9 c6.9,0,12.8,4.8,14.4,11.2c0.3,1.2,0.4,2.4,0.4,3.6c0,1.6-0.2,3.1-0.7,4.5c5,0.8,8.7,5.2,8.7,10.3C64,41.3,63.6,43,62.9,44.4z" transform="translate(-0.52091 0)"> <animateTransform attributeName="transform" type="translate" values="-3 0;3 0;-3 0" keyTimes="0;0.5;1" dur="4.166666666666666" repeatCount="indefinite" calcMode="spline" keySplines="0.5 0 0.5 1;0.5 0 0.5 1"></animateTransform> </path> <clipPath id="ldio-u4u0nkbf73c-cp"><use xlink:href="#ldio-u4u0nkbf73c-path"></use></clipPath> </defs> <g clip-path="url(ldio-u4u0nkbf73c-cp)"> <path fill="#a2d6ff" d="M84.9,28.9c0.4-1.1,0.6-2.3,0.6-3.5c0-1-0.1-1.9-0.4-2.8 c-1.3-5-6.1-8.7-11.8-8.7c-4.6,0-8.7,2.5-10.7,6.1c-0.8-0.2-1.6-0.4-2.4-0.4c-4.5,0-8.1,3.4-8.1,7.6c0,0.5,0.1,1,0.2,1.5 c-4.1,0.6-7.2,4-7.2,8c0,4.5,3.8,8.1,8.6,8.1h29.8c3.3,0,6.2-1.8,7.7-4.4c0.6-1.1,0.9-2.3,0.9-3.7C92,32.9,88.9,29.6,84.9,28.9z" transform="translate(-2.18938 0)"> <animateTransform attributeName="transform" type="translate" values="-3 0;3 0;-3 0" keyTimes="0;0.5;1" dur="2.75" repeatCount="indefinite" calcMode="spline" keySplines="0.5 0 0.5 1;0.5 0 0.5 1"></animateTransform> </path> </g> </g> </svg>',
    
    'clear'=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="200px" height="200px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"> <circle cx="50" cy="50" r="25" fill="#f8e46a"></circle> <g transform="rotate(166.708 50 50)"> <path d="M43 23L57 23L50 10Z" transform="rotate(30 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(60 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(90 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(120 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(150 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(180 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(210 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(240 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(270 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(300 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(330 50 50)" fill="#ffd78a"></path><path d="M43 23L57 23L50 10Z" transform="rotate(360 50 50)" fill="#ffd78a"></path> <animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1.8518518518518516s" values="0 50 50;180 50 50" keyTimes="0;1"></animateTransform> </g></svg>',
    
    'snow'=>'<svg xml:space="preserve" viewBox="0 0 100 100" y="0" x="0" xmlns="http://www.w3.org/2000/svg" id="圖層_1" version="1.1" style="height: 100%; width: 100%; background: none; shape-rendering: auto;" width="128px" height="128px"><g class="ldl-scale" style="transform-origin: 50% 50%; transform: rotate(0deg) scale(0.8, 0.8);"><g class="ldl-ani"><g class="ldl-layer"><g class="ldl-ani" style="transform: scale(0.91); transform-origin: 50px 50px; animation: 1.11111s linear -0.694444s infinite normal forwards running breath-864a88d0-4456-4f10-aa46-3d39bc17c114;"><path fill="#a0c8d7" d="M52 77.6V22.4l9.4-9.4c.8-.8.8-2.1 0-2.9-.8-.8-2.1-.8-2.9 0L52 16.6V7.5c0-1.1-.9-2-2-2s-2 .9-2 2v9.1l-6.5-6.5c-.8-.8-2.1-.8-2.9 0-.8.8-.8 2.1 0 2.9l9.4 9.4v55.2L38.6 87c-.8.8-.8 2.1 0 2.9.4.4.9.6 1.4.6s1-.2 1.4-.6l6.5-6.5v9.1c0 1.1.9 2 2 2s2-.9 2-2v-9.1l6.5 6.5c.4.4.9.6 1.4.6s1-.2 1.4-.6c.8-.8.8-2.1 0-2.9L52 77.6z" style="fill: rgb(160, 200, 215);"></path></g></g><g class="ldl-layer"><g class="ldl-ani" style="transform: scale(0.91); transform-origin: 50px 50px; animation: 1.11111s linear -0.833333s infinite normal forwards running breath-864a88d0-4456-4f10-aa46-3d39bc17c114;"><path fill="#a0c8d7" d="M90.2 60c-.3-1.1-1.4-1.7-2.5-1.4L74.9 62 51 48.2 27.1 34.4l-3.4-12.8c-.3-1.1-1.4-1.7-2.5-1.4-1.1.3-1.7 1.4-1.4 2.5l2.4 8.8-8-4.5c-1-.6-2.2-.2-2.8.7-.6 1-.2 2.2.8 2.8l7.9 4.6-8.8 2.4c-1.1.3-1.7 1.4-1.4 2.5.2.9 1.1 1.5 2 1.5.2 0 .4 0 .5-.1L25.1 38 49 51.8l23.9 13.8 3.4 12.8c.2.9 1.1 1.5 2 1.5.2 0 .4 0 .5-.1 1.1-.3 1.7-1.4 1.4-2.5l-2.4-8.8 7.9 4.6c.3.2.7.3 1 .3.7 0 1.4-.4 1.8-1 .6-1 .2-2.2-.8-2.8L79.8 65l8.8-2.4c1.2-.4 1.9-1.5 1.6-2.6z" style="fill: rgb(160, 200, 215);"></path></g></g><g class="ldl-layer"><g class="ldl-ani" style="transform: scale(0.91); transform-origin: 50px 50px; animation: 1.11111s linear -0.972222s infinite normal forwards running breath-864a88d0-4456-4f10-aa46-3d39bc17c114;"><path fill="#a0c8d7" d="M88.7 37.5l-8.8-2.4 7.9-4.6c1-.6 1.3-1.8.8-2.8-.6-1-1.8-1.3-2.8-.7l-7.9 4.6 2.4-8.8c.3-1.1-.4-2.2-1.4-2.5-1.1-.3-2.2.4-2.5 1.4L73 34.5 49 48.2 25.1 62l-12.8-3.4c-1.1-.3-2.2.4-2.5 1.4-.3 1.1.4 2.2 1.4 2.5l8.8 2.4-7.9 4.6c-1 .6-1.3 1.8-.8 2.8.4.7 1.1 1 1.8 1 .3 0 .7-.1 1-.3l7.9-4.6-2.4 8.8c-.3 1.1.4 2.2 1.4 2.5.2 0 .4.1.5.1.9 0 1.7-.6 2-1.5l3.4-12.8L51 51.8 74.9 38l12.8 3.4c.2 0 .4.1.5.1.9 0 1.7-.6 2-1.5.3-1.1-.4-2.2-1.5-2.5z" style="fill: rgb(160, 200, 215);"></path></g></g><g class="ldl-layer"><g class="ldl-ani"><g><g class="ldl-layer"><g class="ldl-ani" style="transform: scale(0.91); transform-origin: 50px 50px; animation: 1.11111s linear -1.11111s infinite normal forwards running breath-864a88d0-4456-4f10-aa46-3d39bc17c114;"><path fill="#77a4bd" d="M62.9 72.4L50 64.9l-12.9 7.4V57.4L24.2 50l12.9-7.5V27.6L50 35.1l12.9-7.4v14.9L75.8 50l-12.9 7.5v14.9zM50 60.2l8.8 5.1V55.1l8.8-5.1-8.8-5.1V34.7L50 39.8l-8.8-5.1v10.2L32.4 50l8.8 5.1v10.2l8.8-5.1z" style="fill: rgb(119, 164, 189);"></path></g></g></g></g></g><metadata xmlns:d="https://loading.io/stock/"><d:name>snow flake</d:name><d:tags>ice,crystal,polygon,christmas,cold,frozen,snow flake,weather</d:tags><d:license>pro</d:license><d:slug>cbm66s</d:slug></metadata></g></g><style id="breath-864a88d0-4456-4f10-aa46-3d39bc17c114" data-anikit="">@keyframes breath-864a88d0-4456-4f10-aa46-3d39bc17c114 { 0% { animation-timing-function: cubic-bezier(0.9647,0.2413,-0.0705,0.7911); transform: scale(0.9099999999999999); } 51% { animation-timing-function: cubic-bezier(0.9226,0.2631,-0.0308,0.7628); transform: scale(1.02994); } 100% { transform: scale(0.9099999999999999); } }</style></svg>',
    'drizzle'=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="197px" height="197px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"> <defs> <path id="ldio-tyqujdua9a-p1" d="M0 0v100h100V0H0z M62.9 44.4c-1.7 3.4-5.3 5.8-9.4 5.8H17c-5.8 0-10.5-4.7-10.5-10.5 c0-5.2 3.8-9.6 8.9-10.4c-0.1-0.6-0.2-1.3-0.2-2c0-5.5 4.4-9.9 9.9-9.9c1 0 2 0.2 3 0.5c2.5-4.7 7.4-7.9 13.1-7.9 c6.9 0 12.8 4.8 14.4 11.2c0.3 1.2 0.4 2.4 0.4 3.6c0 1.6-0.2 3.1-0.7 4.5c5 0.8 8.7 5.2 8.7 10.3C64 41.3 63.6 43 62.9 44.4z" transform="translate(2.99789 0)"> <animateTransform attributeName="transform" type="translate" values="-3 0;3 0;-3 0" keyTimes="0;0.5;1" dur="10" repeatCount="indefinite" calcMode="spline" keySplines="0.5 0 0.5 1;0.5 0 0.5 1"></animateTransform> </path> <path id="ldio-tyqujdua9a-p2" d="M0 52L58 52L64 47L100 47L100 90L0 90Z"></path> <clipPath id="ldio-tyqujdua9a-cp1"><use xlink:href="#ldio-tyqujdua9a-p1"></use></clipPath> <clipPath id="ldio-tyqujdua9a-cp2"><use xlink:href="#ldio-tyqujdua9a-p2"></use></clipPath> </defs> <g clip-path="url(#ldio-tyqujdua9a-cp2)"><path fill="#ecf8ff" d="M26.1 61.7l1.6-4.3c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-1.6 4.3 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C24.9 63.1 25.8 62.6 26.1 61.7z" transform="translate(-29.2746 78.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="0s"></animateTransform> </path> <path fill="#ecf8ff" d="M34.4 68.6l4.2-11.1c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2L30.4 67 c-0.4 1.1 0.1 2.3 1.2 2.8c0.2 0.1 0.5 0.1 0.8 0.1C33.3 70 34.1 69.4 34.4 68.6z" transform="translate(11.2254 -29.9345)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-0.5s"></animateTransform> </path> <path fill="#ecf8ff" d="M42.7 75.4l6.8-18c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-6.8 18 c-0.4 1.1 0.1 2.3 1.2 2.8c0.2 0.1 0.5 0.1 0.8 0.1C41.6 76.8 42.4 76.3 42.7 75.4z" transform="translate(6.72544 -17.9345)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-1s"></animateTransform> </path> <path fill="#ecf8ff" d="M58.3 63.1l2.1-5.5c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-2.1 5.5 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C57.1 64.5 57.9 63.9 58.3 63.1z" transform="translate(2.22544 -5.9345)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-1.5000000000000002s"></animateTransform> </path> <path fill="#ecf8ff" d="M65.1 74.2l7.3-20.3c0.4-1.1-0.2-2.3-1.3-2.7c-1.1-0.4-2.3 0.2-2.7 1.3l-7.3 20.3 c-0.4 1.1 0.2 2.3 1.3 2.7c0.2 0.1 0.5 0.1 0.7 0.1C64 75.6 64.8 75.1 65.1 74.2z" transform="translate(-2.27456 6.06551)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-2s"></animateTransform> </path> <path fill="#ecf8ff" d="M77.4 66.8l4.3-13.1c0.4-1.1-0.2-2.3-1.4-2.7c-1.1-0.4-2.3 0.2-2.7 1.4l-4.3 13.1 c-0.4 1.1 0.2 2.3 1.4 2.7c0.2 0.1 0.4 0.1 0.7 0.1C76.3 68.3 77.1 67.7 77.4 66.8z" transform="translate(-6.77456 18.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-2.5s"></animateTransform> </path> <path fill="#ecf8ff" d="M16.9 86.4l6.4-17.3c0.4-1.1-0.2-2.3-1.3-2.8c-1.1-0.4-2.3 0.2-2.8 1.3l-6.4 17.3 c-0.4 1.1 0.2 2.3 1.3 2.8c0.2 0.1 0.5 0.1 0.7 0.1C15.7 87.8 16.6 87.2 16.9 86.4z" transform="translate(-11.2746 30.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-3.0000000000000004s"></animateTransform> </path> <path fill="#ecf8ff" d="M27.6 86.4l3.8-9.8c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-3.8 9.8 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C26.5 87.8 27.3 87.3 27.6 86.4z" transform="translate(-15.7746 42.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-3.5000000000000004s"></animateTransform> </path> <path fill="#ecf8ff" d="M38.5 86.4l1-2.7c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-1 2.7 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C37.4 87.8 38.2 87.3 38.5 86.4z" transform="translate(-20.2746 54.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-4s"></animateTransform> </path> <path fill="#ecf8ff" d="M49.3 86.4l5.9-15.2c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-5.9 15.2 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C48.1 87.8 48.9 87.3 49.3 86.4z" transform="translate(-24.7746 66.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-4.5s"></animateTransform> </path> <path fill="#ecf8ff" d="M72.2 81.9l2.9-7.7c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-2.9 7.7 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C71.1 83.3 71.9 82.8 72.2 81.9z" transform="translate(-29.2746 78.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-5s"></animateTransform> </path><path fill="#ecf8ff" d="M26.1 61.7l1.6-4.3c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-1.6 4.3 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C24.9 63.1 25.8 62.6 26.1 61.7z" transform="translate(-6.77456 18.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-2.5s"></animateTransform> </path> <path fill="#ecf8ff" d="M34.4 68.6l4.2-11.1c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2L30.4 67 c-0.4 1.1 0.1 2.3 1.2 2.8c0.2 0.1 0.5 0.1 0.8 0.1C33.3 70 34.1 69.4 34.4 68.6z" transform="translate(-11.2746 30.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-3s"></animateTransform> </path> <path fill="#ecf8ff" d="M42.7 75.4l6.8-18c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-6.8 18 c-0.4 1.1 0.1 2.3 1.2 2.8c0.2 0.1 0.5 0.1 0.8 0.1C41.6 76.8 42.4 76.3 42.7 75.4z" transform="translate(-15.7746 42.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-3.5s"></animateTransform> </path> <path fill="#ecf8ff" d="M58.3 63.1l2.1-5.5c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-2.1 5.5 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C57.1 64.5 57.9 63.9 58.3 63.1z" transform="translate(-20.2746 54.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-4s"></animateTransform> </path> <path fill="#ecf8ff" d="M65.1 74.2l7.3-20.3c0.4-1.1-0.2-2.3-1.3-2.7c-1.1-0.4-2.3 0.2-2.7 1.3l-7.3 20.3 c-0.4 1.1 0.2 2.3 1.3 2.7c0.2 0.1 0.5 0.1 0.7 0.1C64 75.6 64.8 75.1 65.1 74.2z" transform="translate(-24.7746 66.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-4.5s"></animateTransform> </path> <path fill="#ecf8ff" d="M77.4 66.8l4.3-13.1c0.4-1.1-0.2-2.3-1.4-2.7c-1.1-0.4-2.3 0.2-2.7 1.4l-4.3 13.1 c-0.4 1.1 0.2 2.3 1.4 2.7c0.2 0.1 0.4 0.1 0.7 0.1C76.3 68.3 77.1 67.7 77.4 66.8z" transform="translate(-29.2746 78.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-5s"></animateTransform> </path> <path fill="#ecf8ff" d="M16.9 86.4l6.4-17.3c0.4-1.1-0.2-2.3-1.3-2.8c-1.1-0.4-2.3 0.2-2.8 1.3l-6.4 17.3 c-0.4 1.1 0.2 2.3 1.3 2.8c0.2 0.1 0.5 0.1 0.7 0.1C15.7 87.8 16.6 87.2 16.9 86.4z" transform="translate(11.2254 -29.9345)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-5.5s"></animateTransform> </path> <path fill="#ecf8ff" d="M27.6 86.4l3.8-9.8c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-3.8 9.8 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C26.5 87.8 27.3 87.3 27.6 86.4z" transform="translate(6.72544 -17.9345)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-6.000000000000001s"></animateTransform> </path> <path fill="#ecf8ff" d="M38.5 86.4l1-2.7c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-1 2.7 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C37.4 87.8 38.2 87.3 38.5 86.4z" transform="translate(2.22544 -5.9345)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-6.5s"></animateTransform> </path> <path fill="#ecf8ff" d="M49.3 86.4l5.9-15.2c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-5.9 15.2 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C48.1 87.8 48.9 87.3 49.3 86.4z" transform="translate(-2.27456 6.06551)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-7s"></animateTransform> </path> <path fill="#ecf8ff" d="M72.2 81.9l2.9-7.7c0.4-1.1-0.1-2.3-1.2-2.8c-1.1-0.4-2.3 0.1-2.8 1.2l-2.9 7.7 c-0.4 1.1 0.1 2.3 1.2 2.8c0.3 0.1 0.5 0.1 0.8 0.1C71.1 83.3 71.9 82.8 72.2 81.9z" transform="translate(-6.77456 18.0655)"> <animateTransform attributeName="transform" type="translate" values="15 -40;-30 80" keyTimes="0;1" dur="5" repeatCount="indefinite" begin="-7.5s"></animateTransform> </path></g> <path fill="#cbf8ff" d="M53.2 30.3c0.4-1.3 0.6-2.7 0.6-4.2c0-1.2-0.1-2.3-0.4-3.4c-1.5-6-7-10.5-13.5-10.5 c-5.3 0-9.9 3-12.3 7.4c-0.9-0.3-1.8-0.4-2.8-0.4c-5.1 0-9.3 4.1-9.3 9.3c0 0.6 0.1 1.3 0.2 1.9c-4.7 0.7-8.3 4.8-8.3 9.7 c0 5.4 4.4 9.8 9.8 9.8h34.2c3.8 0 7.1-2.2 8.8-5.4c0.7-1.3 1.1-2.9 1.1-4.5C61.4 35.2 57.8 31.1 53.2 30.3z" transform="translate(2.99789 0)"> <animateTransform attributeName="transform" type="translate" values="-3 0;3 0;-3 0" keyTimes="0;0.5;1" dur="10" repeatCount="indefinite" calcMode="spline" keySplines="0.5 0 0.5 1;0.5 0 0.5 1"></animateTransform> </path> <g clip-path="url(#ldio-tyqujdua9a-cp1)"> <path fill="#eefbff" d="M84.9 28.9c0.4-1.1 0.6-2.3 0.6-3.5c0-1-0.1-1.9-0.4-2.8 c-1.3-5-6.1-8.7-11.8-8.7c-4.6 0-8.7 2.5-10.7 6.1c-0.8-0.2-1.6-0.4-2.4-0.4c-4.5 0-8.1 3.4-8.1 7.6c0 0.5 0.1 1 0.2 1.5 c-4.1 0.6-7.2 4-7.2 8c0 4.5 3.8 8.1 8.6 8.1h29.8c3.3 0 6.2-1.8 7.7-4.4c0.6-1.1 0.9-2.3 0.9-3.7C92 32.9 88.9 29.6 84.9 28.9z" transform="translate(0.111241 0)"> <animateTransform attributeName="transform" type="translate" values="-3 0;3 0;-3 0" keyTimes="0;0.5;1" dur="6.6" repeatCount="indefinite" calcMode="spline" keySplines="0.5 0 0.5 1;0.5 0 0.5 1"></animateTransform> </path> </g>',
             
      'haze'=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="200px" height="200px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"> <defs> <linearGradient id="ldio-fuv7wffl6x-gradient" gradientUnits="userSpaceOnUse" x1="50" y1="29" x2="50" y2="7.75"> <stop offset="0" style="stop-color:#ffee99"></stop> <stop offset="0.5" style="stop-opacity:0.3;stop-color:#ffffbb"></stop> <stop offset="1" style="stop-opacity:0;stop-color:#ffffff"></stop> </linearGradient> <path id="ldio-fuv7wffl6x-path" fill="url(#ldio-fuv7wffl6x-gradient)" d="M55.2 30.7l9.7-36.2H35.1l9.7 36.2c1.7-0.4 3.4-0.7 5.2-0.7S53.5 30.3 55.2 30.7z"></path> </defs> <g transform="translate(50 50)"> <g transform="rotate(356.429)"> <animateTransform attributeName="transform" type="rotate" values="0;360" keyTimes="0;1" repeatCount="indefinite" dur="3.3333333333333335s"></animateTransform> <use xlink:href="#ldio-fuv7wffl6x-path" transform="rotate(0) translate(-50 -50)"></use><use xlink:href="#ldio-fuv7wffl6x-path" transform="rotate(45) translate(-50 -50)"></use><use xlink:href="#ldio-fuv7wffl6x-path" transform="rotate(90) translate(-50 -50)"></use><use xlink:href="#ldio-fuv7wffl6x-path" transform="rotate(135) translate(-50 -50)"></use><use xlink:href="#ldio-fuv7wffl6x-path" transform="rotate(180) translate(-50 -50)"></use><use xlink:href="#ldio-fuv7wffl6x-path" transform="rotate(225) translate(-50 -50)"></use><use xlink:href="#ldio-fuv7wffl6x-path" transform="rotate(270) translate(-50 -50)"></use><use xlink:href="#ldio-fuv7wffl6x-path" transform="rotate(315) translate(-50 -50)"></use> </g> </g> <circle fill="#ffdd55" cx="50" cy="50" r="15"></circle></svg>'
       ),
              'translations'  => array(
                  'not_found'=>__('Not Found','wplms')
              )
            )));
        }
    }
    /** @see WP_Widget::widget -- do not rename this */
    function widget( $args, $instance ) {
        extract( $args );
        $title    = $instance['title'];
        $api    = $instance['api'];
        echo '<div class="dash-widget">'.$before_widget;
        echo '<div class="wplms_dash_weather"></div>';
        echo '</div>';
        echo $after_widget.'
        </div>';
                
    }
 
    /** @see WP_Widget::update -- do not rename this */
    function update($new_instance, $old_instance) {   
	    $instance = $old_instance;
	    $instance['title'] = strip_tags($new_instance['title']);
      $instance['api'] = strip_tags($new_instance['api']);
	    return $instance;
    }
 
    /** @see WP_Widget::form -- do not rename this */
    function form($instance) {  
        $defaults = array( 
                        'title'  => __('Weather Widget','wplms'),
                        'api'=>'f4dbde4803faa9218c28f70334f817c2',
                    );
  		  $instance = wp_parse_args( (array) $instance, $defaults );
        $title  = esc_attr($instance['title']);
        $api = esc_attr($instance['api']);
        ?>
        <p>
          <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title','wplms'); ?></label> 
          <input class="regular_text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
          <label for="<?php echo $this->get_field_id('api'); ?>"><?php _e('Api Key from openweathermap.org','wplms'); ?></label> 
          <input class="regular_text" id="<?php echo $this->get_field_id('api'); ?>" name="<?php echo $this->get_field_name('api'); ?>" type="text" value="<?php echo $api; ?>" />
        </p>
        <?php 
    }
} 

?>